CREATE OR REPLACE FUNCTION public.f_mesclar_orcamentos(integer, integer, text, OUT cd_orc integer)
 RETURNS SETOF integer
 LANGUAGE plpgsql
AS $function$



	DECLARE 

	----------------------------------------------

		int_cd_emp ALIAS FOR $1;

		int_cd_filial ALIAS FOR $2;

		var_ListaOrcamentos ALIAS FOR $3;

	----------------------------------------------

		

		dbl_cd_orc bigint;

		arOrcs  double precision array;

		reg est_orc_cpl%ROWTYPE;

		dbl_percDescIt double precision;

		dbl_vlrDescIt double precision;

		dbl_vlrTotIt double precision;

		dbl_Qtit double precision;

		dblCdOrc integer;

		intTpDescIt integer;

		v_sts_orc text;

		rProds record;

		rProds2 record;

		rTotOrc record;

		iNrReg integer;

		iRet integer;

		tmp_pbm integer;

		tmp_televd integer;

		

	BEGIN

	

		---------------------------------------------------------

		----CRIA TABELAS DE AUXILIO

		---------------------------------------------------------

		CREATE TEMPORARY TABLE tmp_est_orc (LIKE est_orc);

		CREATE TEMPORARY TABLE tmp_est_orc_cpl (LIKE est_orc_cpl);

		CREATE TEMPORARY TABLE tmp_est_orc_cpl_concor (LIKE est_orc_cpl_concor); 

		CREATE TEMPORARY TABLE tmp_est_orc_glb_medico (LIKE est_orc_glb_medico); 
		
		CREATE TEMPORARY TABLE tmp_est_orc_cpl_lote (LIKE est_orc_cpl_lote);

		

		--Separa todos os orcamentos da string

		arOrcs = string_to_array(var_ListaOrcamentos,',');

		

		RAISE NOTICE 'Orcamento inicial %', arOrcs[1];

		

		---------------------------------------------------------

		----Carrega dados necessarios

		---------------------------------------------------------

		--Carrega dados do primeiro orcamento selecionado

		INSERT INTO tmp_est_orc 

		SELECT * 

		FROM est_orc as orc 

		WHERE orc.cd_emp=int_cd_emp AND 

			  orc.cd_filial=int_cd_filial AND 

			  orc.cd_orc = arOrcs[1];

		IF NOT FOUND THEN

			RAISE NOTICE 'Falha ao gravar orcamento % na tabela temporaria ', arOrcs[1];

		ELSE

			RAISE NOTICE 'Orcamento % gravado com sucesso na tabela temporaria', arOrcs[1];

		END IF;

		

		IF ((SELECT COUNT (est_orc.tipo_pbm) 

			FROM est_orc 

			WHERE est_orc.cd_emp=int_cd_emp AND 

				  est_orc.cd_filial=int_cd_filial AND 

				  est_orc.cd_orc in (select unnest(arOrcs)) AND

				  tipo_pbm <> -1) > 1)

		THEN

			tmp_pbm =   (SELECT est_orc.cd_orc 

						FROM est_orc

						WHERE est_orc.cd_emp=int_cd_emp AND 

							  est_orc.cd_filial=int_cd_filial AND 

							  est_orc.cd_orc in (select unnest(arOrcs)) AND

							  tipo_pbm <> -1 limit 1);

			RAISE EXCEPTION '2 ou mais PBMs ---> %', tmp_pbm;

		END IF;

		

		IF EXISTS((SELECT 1 

			FROM est_orc 

			WHERE est_orc.cd_emp=int_cd_emp AND 

				  est_orc.cd_filial=int_cd_filial AND 

				  est_orc.cd_orc in (select unnest(arOrcs)) AND

				  nr_ped_televd > 0))

		THEN

			tmp_televd =   	(SELECT est_orc.cd_orc 

							FROM est_orc

							WHERE est_orc.cd_emp=int_cd_emp AND 

								  est_orc.cd_filial=int_cd_filial AND 

								  est_orc.nr_ped_televd > 0 AND

								  est_orc.cd_orc in (select unnest(arOrcs)) limit 1);

			RAISE EXCEPTION '1 ou mais do Televendas ---> %', tmp_televd;

		END IF;

		

		IF EXISTS((SELECT 1 

			FROM est_orc 

			WHERE est_orc.cd_emp=int_cd_emp AND 

				  est_orc.cd_filial=int_cd_filial AND 

				  est_orc.cd_orc in (select unnest(arOrcs)) AND

				  est_orc.sts_orc <> '0'))

		THEN

			tmp_televd =   	(SELECT est_orc.cd_orc 

							FROM est_orc

							WHERE est_orc.cd_emp=int_cd_emp AND 

								  est_orc.cd_filial=int_cd_filial AND 

								  est_orc.nr_ped_televd > 0 AND

								  est_orc.cd_orc in (select unnest(arOrcs)) limit 1);

			RAISE EXCEPTION '1 ou orcamentos com status invalido';

		END IF;

		

		---------------------------------------------------------

		----Mescla orcamentos

		---------------------------------------------------------



		INSERT INTO tmp_est_orc_cpl (cd_emp,cd_filial,cd_orc,cd_prod,qt,vlr_it,vlr_tot_it,vlr_desc,perc_desc,cd_vend,cd_vend_lib,pr_tab,

					oferta,perc_desc_cad,cd_medico_rec,perc_desc_fix,vlr_desc_fix,qtde_ponto_fidel,tipo_desconto,vlr_economia,

					vlr_pbm,vlr_cliente,qt_aut_pbm,vlr_desc_verba,perc_desc_verba,cd_vend_verba,cd_barra,libera_vd_conv,

					vlr_custo_semaforo,qt_est,cd_grp,flag_consolidado,dt_receita,nr_receita,nr_autr_pbm_item,cd_tbl_desc,tp_nivel,

					nr_protocolo_manipulado,vlr_desc_autr_pbm,vlr_it_autr_pbm,perc_desconto_pos_pbm,venda_dependente,cd_it,

					perc_desc_diff,perc_desc_max,ds_prod_orc,perc_desc_min,tp_tbl_desc,dt_emi_it,vlr_frete_rat)

		SELECT tmp.cd_emp,tmp.cd_filial,tmp.cd_orc,tmp.cd_prod,tmp.qt,tmp.vlr_it,tmp.vlr_tot_it,tmp.vlr_desc,tmp.perc_desc,tmp.cd_vend,

					tmp.cd_vend_lib,tmp.pr_tab,tmp.oferta,tmp.perc_desc_cad,tmp.cd_medico_rec,tmp.perc_desc_fix,tmp.vlr_desc_fix,

					tmp.qtde_ponto_fidel,tmp.tipo_desconto,tmp.vlr_economia,tmp.vlr_pbm,tmp.vlr_cliente,tmp.qt_aut_pbm,tmp.vlr_desc_verba,

					tmp.perc_desc_verba,tmp.cd_vend_verba,tmp.cd_barra,tmp.libera_vd_conv,tmp.vlr_custo_semaforo,tmp.qt_est,tmp.cd_grp,

					tmp.flag_consolidado,tmp.dt_receita,tmp.nr_receita,tmp.nr_autr_pbm_item,tmp.cd_tbl_desc,tmp.tp_nivel,tmp.nr_protocolo_manipulado,

					tmp.vlr_desc_autr_pbm,tmp.vlr_it_autr_pbm,tmp.perc_desconto_pos_pbm,tmp.venda_dependente,(row_number() over ()),tmp.perc_desc_diff,

					tmp.perc_desc_max,tmp.ds_prod_orc,tmp.perc_desc_min,tmp.tp_tbl_desc,tmp.dt_emi_it,tmp.vlr_frete_rat 

		FROM est_orc_cpl as tmp 

		WHERE tmp.cd_emp=int_cd_emp AND 

			  tmp.cd_filial=int_cd_filial AND 

			  tmp.cd_orc in (select unnest(arOrcs));

			  

		---------------------------------------------------------

		----EST_ORC_CPL_CONCOR

		---------------------------------------------------------

			

		--Insere o item com maior cd_it + 1 (tmp_cd_it)

		INSERT INTO tmp_est_orc_cpl_concor (cd_emp,cd_filial,cd_prod,nr_orc,dt_cad,cd_vend,cd_concor,

											vlr_concor,perc_desc,flag_consolidado,cd_it)

		SELECT tmp.cd_emp,tmp.cd_filial,tmp.cd_prod,tmp.nr_orc,tmp.dt_cad,tmp.cd_vend,tmp.cd_concor,

				tmp.vlr_concor,tmp.perc_desc,tmp.flag_consolidado,(row_number() over ())

		FROM est_orc_cpl_concor as tmp 

		WHERE tmp.cd_emp= int_cd_emp AND 

			  tmp.cd_filial=int_cd_filial AND 

			  tmp.nr_orc in (select unnest(arOrcs));



		---------------------------------------------------------

		----EST_ORC_GLB_MEDICO

		---------------------------------------------------------

		

		--Insere o item com maior cd_it + 1 (tmp_cd_it)

		INSERT INTO tmp_est_orc_glb_medico (cd_emp,cd_filial,cd_prod,nr_orc,dt_cad,cd_medico_rec,cd_vend,qt_prod,flag_consolidado,

											nr_receita,dt_receita,cd_receita,tp_capt_receita,nm_comprador,idade,nm_paciente,

											receita_tipo,cid,uf,nr_doc_cli,tipo_documento,sexo,tp_doc_exp,cd_it)

		SELECT tmp.cd_emp,tmp.cd_filial,tmp.cd_prod,tmp.nr_orc,tmp.dt_cad,tmp.cd_medico_rec,tmp.cd_vend,tmp.qt_prod,tmp.flag_consolidado,

				tmp.nr_receita,tmp.dt_receita,tmp.cd_receita,tmp.tp_capt_receita,tmp.nm_comprador,tmp.idade,tmp.nm_paciente,

				tmp.receita_tipo,tmp.cid,tmp.uf,tmp.nr_doc_cli,tmp.tipo_documento,tmp.sexo,tmp.tp_doc_exp,(row_number() over ())

		FROM est_orc_glb_medico as tmp 

		WHERE tmp.cd_emp= int_cd_emp AND 

			  tmp.cd_filial=int_cd_filial AND 

			  tmp.nr_orc in (select unnest(arOrcs));



			v_sts_orc =  (select tmp_est_orc.sts_orc from tmp_est_orc limit 1);

			RAISE NOTICE 'Status Or├ºamento 1 temp %', v_sts_orc;	
		
		

		---------------------------------------------------------
		
		----EST_ORC_CPL_LOTE
		
		---------------------------------------------------------
		
		
		--Insere o item com maior cd_it + 1 (tmp_cd_it)
					
		
		INSERT INTO tmp_est_orc_cpl_lote (cd_emp, cd_filial, cd_orc, cd_prod, cd_lote, qtde_lote, cd_it, 
									  dt_fabr, dt_valid, nr_lote, registro_ms, cd_agregador)

				SELECT tmp.cd_emp, tmp.cd_filial, tmp.cd_orc, tmp.cd_prod, tmp.cd_lote, tmp.qtde_lote, (row_number() over ()), 
					   tmp.dt_fabr, tmp.dt_valid, tmp.nr_lote, tmp.registro_ms, tmp.cd_agregador

				FROM est_orc_cpl_lote as tmp 
		
				WHERE tmp.cd_emp = int_cd_emp AND 
		
					  tmp.cd_filial = int_cd_filial AND 
		
					  tmp.cd_orc in (select unnest(arOrcs));
  
				  
		---------------------------------------------------------

		----Atualiza novo orcamento

		---------------------------------------------------------

		v_sts_orc =  (SELECT sts_orc FROM tmp_est_orc);

		RAISE NOTICE 'Status Or├ºamento 2 temp %', v_sts_orc;	

		

		--Obtem o novo cd_orc/nr_orc

		dblCdOrc =  (select nextval('est_orc_seq'));

		

		FOR rTotOrc in SELECT (sum( qt * vlr_it)) as VlrTotOrc, sum(vlr_desc) as VlrTotDesc , sum(vlr_tot_it) as VlrTotLiq

		FROM tmp_est_orc_cpl tmp 

		LOOP

			

			RAISE NOTICE 'Valor total do orcamento : %' , rTotOrc.VlrTotOrc;

			RAISE NOTICE 'Valor total do desconto : %' , rTotOrc.VlrTotDesc;

			RAISE NOTICE 'Valor liquido do orcamento : %' , rTotOrc.VlrTotLiq;

			

			--Atualiza as informacoes do novo orcamento

			UPDATE tmp_est_orc 

			SET cd_orc = dblCdOrc,

				vlr_tot  = rTotOrc.VlrTotOrc,

				vlr_desc = rTotOrc.VlrTotDesc,

				vlr_desc_geral = 0,

				vlr_prod = rTotOrc.VlrTotLiq;

		END LOOP;

		

		UPDATE tmp_est_orc_cpl 

		SET cd_orc = dblCdOrc;

		

		UPDATE tmp_est_orc_cpl_concor 

		SET nr_orc = dblCdOrc;

		

		UPDATE tmp_est_orc_glb_medico 

		SET nr_orc = dblCdOrc;
	

		UPDATE tmp_est_orc_cpl_lote 

		SET cd_orc = dblCdOrc;


		RAISE NOTICE 'INICIANDO GRAVACAO ORCAMENTO %',dblCdOrc ; 

		UPDATE tmp_est_orc 

		SET sts_orc =0;



		BEGIN	 

			INSERT INTO est_orc 

			SELECT * 

			FROM tmp_est_orc;

			  

			---------------------------------------------------------

			----Prevencao de erro

			---------------------------------------------------------

			GET DIAGNOSTICS iNrReg = ROW_COUNT;

			  

			IF iNrReg >= 1   THEN

				RAISE NOTICE 'est_orc GRAVADA COM SUCESSO';

			ELSE

				iRet = -1 ;

				

				RAISE EXCEPTION 'Falha ao gravar est_orc %',iRet;

				RETURN QUERY SELECT iRet,0,0;

			END IF;

			

			--EST_ORC_CPL

			iNrReg = 0;

			  

			INSERT INTO est_orc_cpl

			SELECT * 

			FROM tmp_est_orc_cpl;	 

			  

			GET DIAGNOSTICS iNrReg = ROW_COUNT;

			

			IF iNrReg >= 1  THEN

				RAISE NOTICE 'est_orc_cpl GRAVADA COM SUCESSO';

			ELSE

				iRet = -1 ;

				RAISE EXCEPTION 'Falha ao gravar est_orc_cpl %',iRet;		      

			END IF;

			

			--EST_ORC_CPL_CONCOR

			iNrReg = 0;

  

			INSERT INTO est_orc_cpl_concor

			SELECT * 

			FROM tmp_est_orc_cpl_concor;	 

			  

			GET DIAGNOSTICS iNrReg = ROW_COUNT;

			

			IF iNrReg >= 1  THEN

				RAISE NOTICE 'est_orc_cpl_concor GRAVADA COM SUCESSO';

			ELSE

				RAISE NOTICE 'est_orc_cpl_concor GRAVADA SEM REGISTROS';

			END IF;

			

			--EST_ORC_GLB_MEDICO

			iNrReg = 0;

			  

			INSERT INTO est_orc_glb_medico

			SELECT * 

			FROM tmp_est_orc_glb_medico;	 

			  

			GET DIAGNOSTICS iNrReg = ROW_COUNT;

			

			IF iNrReg >= 1  THEN

				RAISE NOTICE 'est_orc_glb_medico GRAVADA COM SUCESSO';

			ELSE

				RAISE NOTICE 'est_orc_glb_medico GRAVADA SEM REGISTROS';      

			END IF;


			--EST_ORC_CPL_LOTE

			iNrReg = 0;

			INSERT INTO est_orc_cpl_lote

			SELECT * 

			FROM tmp_est_orc_cpl_lote;	 

			GET DIAGNOSTICS iNrReg = ROW_COUNT;

			IF iNrReg >= 1  THEN

				RAISE NOTICE 'est_orc_cpl_lote GRAVADA COM SUCESSO';

			ELSE

				RAISE NOTICE 'est_orc_cpl_lote GRAVADA SEM REGISTROS';      

			END IF;
			

			iNrReg = 0;

			--RAISE NOTICE 'Or├ºamentos %', select unnest(arOrcs);

			INSERT INTO est_orc_mesclagem (

			SELECT orc.cd_emp,orc.cd_filial,dblCdOrc,orc.cd_orc 

			FROM est_orc as orc 

			WHERE orc.cd_emp =  int_cd_emp AND 

				  orc.cd_filial=int_cd_filial AND 

				  orc.cd_orc in (select unnest(arOrcs)));

			

			GET DIAGNOSTICS iNrReg = ROW_COUNT;

			IF iNrReg >= 1  THEN

				RAISE NOTICE 'est_orc_mesclagem GRAVADA COM SUCESSO';

			ELSE

				iRet = -1 ;

				RAISE EXCEPTION 'Falha ao gravar est_orc_mesclagem %',iRet;

			END IF;

		END;

		iRet = 1;



		--Cancela o orcamento mesclado

		UPDATE est_orc 

		SET sts_orc = '2' 

		WHERE est_orc.cd_emp=int_cd_emp AND 

			  est_orc.cd_filial=int_cd_filial AND 

			  est_orc.cd_orc in (select unnest(arOrcs));

		

		RETURN QUERY SELECT dblCdOrc;

		

		RAISE NOTICE 'MESCLAGEM CONCLUIDA COM SUCESSO'; 	

		DROP TABLE tmp_est_orc;

		DROP TABLE tmp_est_orc_cpl;

		DROP TABLE tmp_est_orc_cpl_concor;

		DROP TABLE tmp_est_orc_glb_medico;
		
		DROP TABLE tmp_est_orc_cpl_lote;

	END; --FIM DOS BLOCOS DA FUNCAO



$function$
;
